/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.cyclops.colossalchests.Advancements;
import org.cyclops.colossalchests.RegistryEntries;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.cyclopscore.block.BlockWithEntityGui;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.jetbrains.annotations.Nullable;

public class ColossalChest
extends BlockWithEntityGui
implements CubeDetector.IDetectionListener,
IBlockChestMaterial {
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    private final ChestMaterial material;

    public ColossalChest(BlockBehaviour.Properties properties, ChestMaterial material) {
        super(properties, BlockEntityColossalChest::new);
        this.material = material;
        material.setBlockCore(this);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public MenuProvider m_7246_(BlockState p_49234_, Level p_49235_, BlockPos p_49236_) {
        return super.m_7246_(p_49234_, p_49235_, p_49236_);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? ColossalChest.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_COLOSSAL_CHEST, BlockEntityColossalChest::lidAnimateTick) : null;
    }

    public void m_7458_(BlockState blockState, ServerLevel level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BlockEntityColossalChest) {
            BlockEntityColossalChest uncolossalChest = (BlockEntityColossalChest)blockEntity;
            uncolossalChest.recheckOpen();
        }
    }

    public String m_7705_() {
        String baseKey = super.m_7705_();
        return baseKey.substring(0, baseKey.lastIndexOf(95));
    }

    @Override
    public ChestMaterial getMaterial() {
        return this.material;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENABLED});
    }

    public static boolean canPlace(LevelReader world, BlockPos pos) {
        for (Direction side : Direction.values()) {
            BlockState blockState = world.m_8055_(pos.m_142300_(side));
            Block block = blockState.m_60734_();
            if (!(block instanceof ColossalChest) && !(block instanceof ChestWall) && !(block instanceof Interface) || !blockState.m_61147_().contains(ENABLED) || !((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public RenderShape m_7514_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)ENABLED) != false ? RenderShape.ENTITYBLOCK_ANIMATED : super.m_7514_(blockState);
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return (Boolean)blockState.m_61143_((Property)ENABLED);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public static DetectionResult triggerDetector(ChestMaterial material, LevelAccessor world, BlockPos blockPos, boolean valid, @javax.annotation.Nullable Player player) {
        BlockState blockState;
        DetectionResult detectionResult = material.getChestDetector().detect((LevelReader)world, blockPos, valid ? null : blockPos, (CubeDetector.IValidationAction)new MaterialValidationAction(), true);
        if (player instanceof ServerPlayer && detectionResult.getError() == null && ((Boolean)(blockState = world.m_8055_(blockPos)).m_61143_((Property)ENABLED)).booleanValue()) {
            BlockEntityColossalChest tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityColossalChest.class).orElse(null);
            if (tile == null) {
                BlockPos corePos = ColossalChest.getCoreLocation(material, (LevelReader)world, blockPos);
                tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)corePos, BlockEntityColossalChest.class).orElse(null);
            }
            Advancements.CHEST_FORMED.test((ServerPlayer)player, material, tile.getSizeSingular());
        }
        return detectionResult;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntityColossalChest tile;
        super.m_6402_(world, pos, state, placer, stack);
        if (stack.m_41788_() && (tile = (BlockEntityColossalChest)BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityColossalChest.class).orElse(null)) != null) {
            tile.setCustomName(stack.m_41786_());
            tile.setSize(Vec3i.f_123288_);
        }
        ColossalChest.triggerDetector(this.material, (LevelAccessor)world, pos, true, placer instanceof Player ? (Player)placer : null);
    }

    public void m_6807_(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.m_6807_(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.m_60734_() != blockStateOld.m_60734_() && !((Boolean)blockStateNew.m_61143_((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (LevelAccessor)world, blockPos, true, null);
        }
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.m_8055_(location).m_60734_();
        if (block == this) {
            ((LevelWriter)world).m_7731_(location, (BlockState)world.m_8055_(location).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(valid)), 2);
            BlockEntityColossalChest tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)location, BlockEntityColossalChest.class).orElse(null);
            if (tile != null) {
                tile.setMaterial(this.material);
                tile.setSize(valid ? size : Vec3i.f_123288_);
                tile.setCenter(new Vec3((double)originCorner.m_123341_() + (double)size.m_123341_() / 2.0, (double)originCorner.m_123342_() + (double)size.m_123342_() / 2.0, (double)originCorner.m_123343_() + (double)size.m_123343_() / 2.0));
                tile.addInterface((Vec3i)location);
            }
        }
    }

    @javax.annotation.Nullable
    public static BlockPos getCoreLocation(ChestMaterial material, LevelReader world, BlockPos blockPos) {
        Wrapper tileLocationWrapper = new Wrapper();
        material.getChestDetector().detect(world, blockPos, null, (location, blockState) -> {
            if (blockState.m_60734_() instanceof ColossalChest) {
                tileLocationWrapper.set((Object)location);
            }
            return null;
        }, false);
        return (BlockPos)tileLocationWrapper.get();
    }

    public static void addPlayerChatError(ChestMaterial material, Level world, BlockPos blockPos, Player player, InteractionHand hand) {
        if (!world.f_46443_ && player.m_21120_(hand).m_41619_()) {
            DetectionResult result = material.getChestDetector().detect((LevelReader)world, blockPos, null, (CubeDetector.IValidationAction)new MaterialValidationAction(), false);
            if (result != null && result.getError() != null) {
                ColossalChest.addPlayerChatError(player, result.getError());
            } else {
                player.m_6352_((Component)new TranslatableComponent("multiblock.colossalchests.error.unexpected"), Util.f_137441_);
            }
        }
    }

    public static void addPlayerChatError(Player player, Component error) {
        TextComponent chat = new TextComponent("");
        MutableComponent prefix = new TextComponent("[").m_7220_((Component)new TranslatableComponent("multiblock.colossalchests.error.prefix")).m_7220_((Component)new TextComponent("]: ")).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("multiblock.colossalchests.error.prefix.info"))));
        chat.m_7220_((Component)prefix);
        chat.m_7220_(error);
        player.m_6352_((Component)chat, Util.f_137441_);
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, Player player, BlockPos blockPos, InteractionHand hand, BlockHitResult rayTraceResult) {
        BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityColossalChest.class).ifPresent(tile -> packetBuffer.writeInt(tile.getInventory().m_6643_()));
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (!((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue()) {
            ColossalChest.addPlayerChatError(this.material, world, blockPos, player, hand);
            return InteractionResult.FAIL;
        }
        return super.m_6227_(blockState, world, blockPos, player, hand, rayTraceResult);
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, world, blockPos, false, null);
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (((Boolean)world.m_8055_(pos).m_61143_((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (LevelAccessor)world, pos, false, null);
        }
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        this.m_7592_(world, pos, explosion);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        if (this.material.isExplosionResistant()) {
            return 10000.0f;
        }
        return 0.0f;
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos blockPos) {
        return super.m_7898_(blockState, world, blockPos) && ColossalChest.canPlace(world, blockPos);
    }

    public void m_6810_(BlockState oldState, Level world, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (oldState.m_60734_().getClass() != newState.m_60734_().getClass()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityColossalChest.class).ifPresent(tile -> {
                SimpleInventory lastInventory = tile.getLastValidInventory();
                InventoryHelpers.dropItems((Level)world, (Container)(lastInventory != null ? lastInventory : tile.getInventory()), (BlockPos)blockPos);
            });
            super.m_6810_(oldState, world, blockPos, newState, isMoving);
        }
    }

    private static class MaterialValidationAction
    implements CubeDetector.IValidationAction {
        private final Wrapper<ChestMaterial> requiredMaterial = new Wrapper(null);

        public Component onValidate(BlockPos blockPos, BlockState blockState) {
            ChestMaterial material = null;
            if (blockState.m_60734_() instanceof IBlockChestMaterial) {
                material = ((IBlockChestMaterial)blockState.m_60734_()).getMaterial();
            }
            if (this.requiredMaterial.get() == null) {
                this.requiredMaterial.set((Object)material);
                return null;
            }
            return this.requiredMaterial.get() == material ? null : new TranslatableComponent("multiblock.colossalchests.error.material", new Object[]{new TranslatableComponent(material.getUnlocalizedName()), LocationHelpers.toCompactString((BlockPos)blockPos), new TranslatableComponent(((ChestMaterial)((Object)this.requiredMaterial.get())).getUnlocalizedName())});
        }
    }
}

